﻿using System;
using HIPS.Web.Components.ServiceModel;

namespace HIPS.Web.ModelInterface.Common
{

    /// <summary>
    /// Defines the operations to be supported by an implementation of a patient repository.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="21 November 2013">Initial version.</change>
    /// </history>
    public interface IPatientRepository : IDisposable
    {

        #region Methods

        /// <summary>
        /// Retrieves a list of patients who are currently admitted to (and have not been discharged from) a specified hospital.
        /// </summary>
        /// <param name="hospitalCodeSystem">Code system used to identify the hospital.</param>
        /// <param name="hospitalCode">Code within the specified code system used to identify the hospital.</param>
        /// <param name="withPcehr">Boolean value indicating whether to list patients with (true) or without (false) a PCEHR. Null indicates all patients should be listed regardless of whether they have a PCEHR.</param>
        /// <param name="operatingUser">User requesting the operation.</param>
        /// <returns>PatientListResponse containing the results of the operation.</returns>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="21 November 2013">Initial version.</change>
        /// </history>
        ServiceResponse<PatientSchemas.PatientListResponse> ListPatientsCurrentlyInHospital(string hospitalCodeSystem, string hospitalCode, bool? withPcehr, CommonSchemas.UserDetails operatingUser);

        #endregion

    }
}
